/*
 * Decompiled with CFR 0.152.
 */
package apicore.mu.pdu;

import apicore.mu.pdu.SegmentHeader;
import apicore.mu.pdu.TcpOption;
import apicore.ptmp.PtmpBuffer;
import java.util.ArrayList;

public class TcpHeader
extends SegmentHeader {
    public int seqNum = 0;
    public int ackNum = 0;
    public byte dataOffset = 0;
    public byte reserved = 0;
    public byte control = 0;
    public short windowSize = 0;
    public short checksum = 0;
    public short urgptr = 0;
    public ArrayList<TcpOption> options = new ArrayList();

    public void serialize(PtmpBuffer ptmpBuffer) {
        super.serialize(ptmpBuffer);
        ptmpBuffer.putInt(this.seqNum);
        ptmpBuffer.putInt(this.ackNum);
        ptmpBuffer.putByte(this.dataOffset);
        ptmpBuffer.putByte(this.reserved);
        ptmpBuffer.putByte(this.control);
        ptmpBuffer.putShort(this.windowSize);
        ptmpBuffer.putShort(this.checksum);
        ptmpBuffer.putShort(this.urgptr);
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).serialize(ptmpBuffer);
        }
    }

    public boolean deserialize(PtmpBuffer ptmpBuffer) {
        if (!super.deserialize(ptmpBuffer)) {
            return false;
        }
        try {
            this.seqNum = ptmpBuffer.getInt();
            this.ackNum = ptmpBuffer.getInt();
            this.dataOffset = ptmpBuffer.getByte();
            this.reserved = ptmpBuffer.getByte();
            this.control = ptmpBuffer.getByte();
            this.windowSize = ptmpBuffer.getShort();
            this.checksum = ptmpBuffer.getShort();
            this.urgptr = ptmpBuffer.getShort();
            int n = 0;
            for (int i = 0; i < n; ++i) {
                this.options.set(i, TcpOption.create(ptmpBuffer));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static TcpHeader create(PtmpBuffer ptmpBuffer) {
        TcpHeader tcpHeader = new TcpHeader();
        if (tcpHeader.deserialize(ptmpBuffer)) {
            return tcpHeader;
        }
        return null;
    }

    public String getTypeName() {
        return "CTcpHeader";
    }

    public String toString() {
        String string = "";
        string = string + super.toString();
        string = string + "[TcpHeader: ";
        string = string + "seqNum=" + this.seqNum + ", ";
        string = string + "ackNum=" + this.ackNum + ", ";
        string = string + "dataOffset=" + this.dataOffset + ", ";
        string = string + "reserved=" + this.reserved + ", ";
        string = string + "control=" + this.control + ", ";
        string = string + "windowSize=" + this.windowSize + ", ";
        string = string + "checksum=" + this.checksum + ", ";
        string = string + "urgptr=" + this.urgptr + "]";
        for (int i = 0; i < this.options.size(); ++i) {
            string = string + this.options.get(i).toString();
        }
        return string;
    }
}

